import java.util.HashMap;
import java.util.Iterator;

public class Steuerung
{

    private Sudoku sudoku;
    private static final String VERSION = "Version 1.6";

    private HashMap<Integer, SudokuDatenbank> alleGespeichertenSudokus;
    private int aktuellesSudoku;

    public Benutzerschnittstelle benutzerschnittstelle;
    public Steuerung()
    {
        initialisiereSudokuDatenbank();
        benutzerschnittstelle = new Benutzerschnittstelle(this);
    }

    //Sudoku initialisieren

    private void initialisiereSudokuDatenbank()
    {
        alleGespeichertenSudokus = new HashMap<Integer, SudokuDatenbank> ();
        alleGespeichertenSudokus.put(new Integer(1), new SudokuDatenbankSpiel1("Sudoku 1", "Oh my God. They killed Kenny......You Bastards!"));
        alleGespeichertenSudokus.put(new Integer(2), new SudokuDatenbankSpiel2("Sudoku 2", "Drugs are bad mKay"));
        alleGespeichertenSudokus.put(new Integer(3), new SudokuDatenbankSpiel3("Sudoku 3", "Dont forget your towel"));
    }

    public String gibLoesungswortVonAktuellemSudoku()
    {
        return alleGespeichertenSudokus.get(aktuellesSudoku).gibLoesungswort();
    }
    
    public String gibName(int pNummer)
    {
        return alleGespeichertenSudokus.get(pNummer).gibName();
    }
    
    public int gibAnzahlGespeicherterSudokus()
    {
        return alleGespeichertenSudokus.size();
    }

    public void ladeSudoku(Integer pInteger)
    {
        sudoku = null;
        aktuellesSudoku = pInteger.intValue();
        sudoku = alleGespeichertenSudokus.get(pInteger).sudokuInitialisieren();
    }

    //Methoden auf Sudoku anwenden

    public int getZahlFeld (int pPositionX, int pPositionY)
    {
        if (istSudokuInitialisiert())
        {
            return sudoku.gibZahl(pPositionX, pPositionY);
        }
        else 
        {
            System.out.println("Sudoku nicht initialisiert.     getZahlFeld,steuerung");
            return -1;
        }
    }

    /**
     * Setzt die zahl des aktuellen Feldes
     */
    public void setzteZahlAktuellesFeld(int pWert)
    {
        if (istSudokuInitialisiert())
        {
            sudoku.setzeZahlAktuellesFeld (pWert);
        }
    }

    /**
     * @param pX, pY  sind die parameter der neuen feldposition
     */
    public void setzeAktuellesFeld(int pX, int pY)
    {
        if (istSudokuInitialisiert())
        {
            sudoku.setzeAktuellesFeld (pX, pY);
        }
    }
    
    /**
     * prueft, ob pX und pY das aktuelle Feld sind
     */
    public boolean istAktuellesFeld(int pX, int pY)
    {
        if (istSudokuInitialisiert())
        {
            return sudoku.istAktuellesFeld(pX, pY);
        }
        else
        {
            return false;
        }
    }
    
    public boolean hatSudokuAktuellesFeld()
    {
        if (istSudokuInitialisiert())
        {
            return sudoku.hatAktuellesFeld();
        }
        else
        {
            return false;
        }
    }

    public boolean istFeldVeraenderbar(int pX, int pY)
    {
        if (istSudokuInitialisiert())
        {
            return sudoku.istVeraenderbar(pX, pY);
        }
        else
        {
            return false;
        }
    }
    
    public int gibSeitenLaengeVonSudoku()
    {
        if (istSudokuInitialisiert())
        {
            return sudoku.gibSeitenLaenge();
        }
        else 
        {
            System.out.println("Sudoku nicht initialisiert.     gibSeitenlaenge,steuerung");
            return -1;
        }
    }

    //Solver
    public boolean testeObAlleZahlenAusgefuelltSind()
    {
        return Solver.testetesteObAlleZahlenAusgefuelltSind(sudoku.clone());
    }

    /**
     * es wird getestet, ob schon eine zahl mehrfach vorhanden ist.
     * @return true  wenn das sudoku noch keine doppelten Zahlen hat.
     */
    public boolean testeObSudokuKorrektIst()
    {
        return Solver.testeObSudokuKorrektIst(sudoku.clone()); 
    }

    public boolean spielIstGewonnen()
    {
        return (testeObSudokuKorrektIst() && testeObAlleZahlenAusgefuelltSind());
    }

    public boolean istSudokuInitialisiert()
    {
        if (sudoku == null)
        {
            return false;
        }

        if (sudoku.besitztFeld() == true)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    //Version
    public String gibVersion()
    {
        return VERSION;
    }

}

